/****** Object:  StoredProcedure [dbo].[usp_Filter_Cancelable_Order]    Script Date: 06/15/2012 13:20:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Cancelable_Order]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Cancelable_Order]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--
-- =============================================
-- Author		:	mihaia
-- Created date	:	06/06/2012
-- Description	:	Gets all the cancelable orders.
-- =============================================
-- =============================================
-- Update by:	silvicap
-- Update date: 25.10.2012
-- Description:	Separated orders from acts. 
-- =============================================

CREATE PROCEDURE [dbo].[usp_Filter_Cancelable_Order] 
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@ADMISSION_VALUE int = 1,
	@MOVEMENT_VALUE int = 2,
	@DISCHARGE_VALUE int = 3
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @ORDERED_DATE DATETIME
	SET @ORDERED_DATE = DATEADD(DAY, -10, GETUTCDATE())

	CREATE TABLE #patients (PATIENT_UID UNIQUEIDENTIFIER, WARD_UID UNIQUEIDENTIFIER)

	INSERT INTO #patients (PATIENT_UID, WARD_UID)
	SELECT DISTINCT PATIENT_UID, WARD_UID 
	FROM ADMISSION_EVN 
		WHERE HAS_DISCHARGE = 0 AND VISTA_SITE_UID = @VISTA_SITE_UID AND WARD_UID IS NOT NULL
		
	(
		SELECT AR.ID, AR.IEN, AR.ORDERED_DATE, AR.DOMAIN_ID, AR.PATIENT_UID, @ADMISSION_VALUE AS ACT_TYPE
		FROM ADMISSION_REQ AS AR
			INNER JOIN #patients AS P ON AR.PATIENT_UID = P.PATIENT_UID AND AR.WARD_UID = P.WARD_UID
		WHERE AR.IS_ACTIVE = 1 AND AR.VISTA_SITE_UID = @VISTA_SITE_UID
		UNION ALL
		SELECT MR.ID, MR.IEN, MR.ORDERED_DATE, MR.DOMAIN_ID, MR.PATIENT_UID, @MOVEMENT_VALUE AS ACT_TYPE
		FROM MOVEMENT_REQ AS MR
			INNER JOIN #patients AS P ON MR.PATIENT_UID = P.PATIENT_UID AND MR.WARD_UID = P.WARD_UID
		WHERE MR.IS_ACTIVE = 1 AND MR.VISTA_SITE_UID = @VISTA_SITE_UID
		UNION ALL
		SELECT DR.ID, DR.IEN, DR.ORDERED_DATE, DR.DOMAIN_ID, DR.PATIENT_UID, @DISCHARGE_VALUE AS ACT_TYPE
		FROM DISCHARGE_REQ AS DR
			INNER JOIN #patients AS P ON DR.PATIENT_UID = P.PATIENT_UID AND DR.WARD_UID = P.WARD_UID
		WHERE DR.IS_ACTIVE = 1 AND DR.VISTA_SITE_UID = @VISTA_SITE_UID
	)
	UNION
	(
		SELECT AR.ID, AR.IEN, AR.ORDERED_DATE, AR.DOMAIN_ID, AR.PATIENT_UID, @ADMISSION_VALUE AS ACT_TYPE
		FROM ADMISSION_REQ AS AR
		WHERE AR.IS_ACTIVE = 1 AND AR.VISTA_SITE_UID = @VISTA_SITE_UID AND AR.ORDERED_DATE >= @ORDERED_DATE
		UNION ALL
		SELECT MR.ID, MR.IEN, MR.ORDERED_DATE, MR.DOMAIN_ID, MR.PATIENT_UID, @MOVEMENT_VALUE AS ACT_TYPE
		FROM MOVEMENT_REQ AS MR
		WHERE MR.IS_ACTIVE = 1 AND MR.VISTA_SITE_UID = @VISTA_SITE_UID AND MR.ORDERED_DATE >= @ORDERED_DATE
		UNION ALL
		SELECT DR.ID, DR.IEN, DR.ORDERED_DATE, DR.DOMAIN_ID, DR.PATIENT_UID, @DISCHARGE_VALUE AS ACT_TYPE
		FROM DISCHARGE_REQ AS DR
		WHERE DR.IS_ACTIVE = 1 AND DR.VISTA_SITE_UID = @VISTA_SITE_UID AND DR.ORDERED_DATE >= @ORDERED_DATE
	)
	
	DROP TABLE #patients

END
GO